/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsCollectionContainingTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsCollectionContaining.hasItem((Matcher)IsEqual.equalTo((Object)"irrelevant"));
    }

    public void testMatchesACollectionThatContainsAnElementMatchingTheGivenMatcher() {
        Matcher itemMatcher = IsCollectionContaining.hasItem((Matcher)IsEqual.equalTo((Object)"a"));
        IsCollectionContainingTest.assertMatches("should match list that contains 'a'", itemMatcher, Arrays.asList("a", "b", "c"));
    }

    public void testDoesNotMatchCollectionThatDoesntContainAnElementMatchingTheGivenMatcher() {
        Matcher matcher1 = IsCollectionContaining.hasItem(IsCollectionContainingTest.mismatchable("a"));
        IsCollectionContainingTest.assertMismatchDescription("mismatched: b, mismatched: c", matcher1, Arrays.asList("b", "c"));
        Matcher matcher2 = IsCollectionContaining.hasItem((Matcher)IsEqual.equalTo((Object)"a"));
        IsCollectionContainingTest.assertMismatchDescription("", matcher2, new ArrayList());
    }

    public void testDoesNotMatchNull() {
        IsCollectionContainingTest.assertDoesNotMatch("should not matches null", IsCollectionContaining.hasItem((Matcher)IsEqual.equalTo((Object)"a")), null);
    }

    public void testHasAReadableDescription() {
        IsCollectionContainingTest.assertDescription("a collection containing \"a\"", IsCollectionContaining.hasItem((Matcher)IsEqual.equalTo((Object)"a")));
    }

    public void testCanMatchItemWhenCollectionHoldsSuperclass() {
        HashSet<Integer> s = new HashSet<Integer>();
        s.add(2);
        MatcherAssert.assertThat(s, (Matcher)new IsCollectionContaining((Matcher)new IsEqual((Object)2)));
        MatcherAssert.assertThat(s, (Matcher)IsCollectionContaining.hasItem((Object)2));
    }

    public void testMatchesAllItemsInCollection() {
        Matcher matcher1 = IsCollectionContaining.hasItems((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b"), IsEqual.equalTo((Object)"c")});
        IsCollectionContainingTest.assertMatches("should match list containing all items", matcher1, Arrays.asList("a", "b", "c"));
        Matcher matcher2 = IsCollectionContaining.hasItems((Object[])new String[]{"a", "b", "c"});
        IsCollectionContainingTest.assertMatches("should match list containing all items (without matchers)", matcher2, Arrays.asList("a", "b", "c"));
        Matcher matcher3 = IsCollectionContaining.hasItems((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b"), IsEqual.equalTo((Object)"c")});
        IsCollectionContainingTest.assertMatches("should match list containing all items in any order", matcher3, Arrays.asList("c", "b", "a"));
        Matcher matcher4 = IsCollectionContaining.hasItems((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b"), IsEqual.equalTo((Object)"c")});
        IsCollectionContainingTest.assertMatches("should match list containing all items plus others", matcher4, Arrays.asList("e", "c", "b", "a", "d"));
        Matcher matcher5 = IsCollectionContaining.hasItems((Matcher[])new Matcher[]{IsEqual.equalTo((Object)"a"), IsEqual.equalTo((Object)"b"), IsEqual.equalTo((Object)"c")});
        IsCollectionContainingTest.assertDoesNotMatch("should not match list unless it contains all items", matcher5, Arrays.asList("e", "c", "b", "d"));
    }

    private static Matcher<? super String> mismatchable(final String string) {
        return new TypeSafeDiagnosingMatcher<String>(){

            protected boolean matchesSafely(String item, Description mismatchDescription) {
                if (string.equals(item)) {
                    return true;
                }
                mismatchDescription.appendText("mismatched: " + item);
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("mismatchable: " + string);
            }
        };
    }
}

